/* 
 *  EditOrAddIntrinsicRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.Logger;

public class EditOrAddIntrinsicRequest extends InteractionRequest {

    private static final Logger LOG = Logger.getLogger(EditOrAddIntrinsicRequest.class);
    private final String intrinsicName;
    private final String intrinsicValue;

    public EditOrAddIntrinsicRequest(String interactionID, String intrinsicName, String intrinsicValue) {
        super(LOG, interactionID);
        this.intrinsicName = intrinsicName;
        this.intrinsicValue = intrinsicValue;
    }

    /**
     * The call method executes on the outgoingRequest thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.trace(methodName + "+");
        getInteraction().setIntrinsic(intrinsicName, intrinsicValue);
        LOG.trace(methodName + "-");
        return null;
    }
}
